 ; Ŀ
 ;   AddText - create new text beneath an existing line.                   
 ;   Rewritten by the expert technicians at Rocket Industries to allow     
 ;   justifications other than Base.                                       
 ;                                                                         
 ; 

 ; Ŀ
 ;   Justo - returns a string describing the justification of the text     
 ;   entity whose data was passed as its sole argument.  "none" is         
 ;   returned for standard left justification.                             
 ; 
 (DEFUN JUSTO (entt / xjust yjust xjst yjst justrg)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "b"))      ; bottom
        ((= yjust 2) (setq yjst "m"))      ; middle
        ((= yjust 3) (setq yjst "t")))     ; top
  (cond ((= xjust 0) (setq xjst "l"))      ; left
        ((= xjust 1) (setq xjst "c"))      ; centre
        ((= xjust 2) (setq xjst "r"))      ; right
        ((= xjust 3) (setq xjst "a"))      ; aligned
        ((= xjust 4) (setq xjst "m"))      ; middle
        ((= xjust 5) (setq xjst "f")))     ; fit
  (setq justrg (strcat yjst xjst))
 (if (= justrg "l") "none" justrg))
 ; Ŀ
 ;   Justo end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Stone - set a style to a width.                                       
 ;   Arguments: Stnam, a style name.                                       
 ;              Widda, the desired width.                                  
 ; 
 (DEFUN STONE (stnam widda / stylc phont hite)
  (setq stylc (tblsearch "style" stnam))
  (setq phont (cdr (assoc 3 stylc)))
  (setq hite (cdr (assoc 40 stylc)))
  (command ".-style" stnam phont hite widda)
  (while (= 1 (getvar "cmdactive")) (command ""))
 (princ))
 ; Ŀ
 ;   Stone end.                                                            
 ; 

 ; Ŀ
 ;   Addtext.                                                              
 ; 
 (DEFUN C:ADDTEXT (/ prev *error* zeroht cs czs cc cl clt entt enam nl justrg
                                                            stnam wida ecolor)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Save system variables.                                                
 ; 
  (setq cs (getvar "textstyle"))
  (setq czs (getvar "textsize"))
  (setq cc (getvar "cecolor"))
  (setq cl (getvar "clayer"))
  (setq clt (getvar "celtype"))
  (setq teddy (getvar "dtexted"))
 ; Ŀ
 ;   Reset the bloody in-place text edit and create as opposed to          
 ;   in-place dtext creation system variable.                              
 ; 
  (if teddy (setvar "dtexted" 1))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (write-line (strcat "\n" shk)))
   (setvar "textsize" czs)
   (setvar "textstyle" cs)
   (setvar "cecolor" cc)
   (setvar "clayer" cl)
   (setvar "celtype" clt)
   (if teddy (setvar "dtexted" teddy))
  (princ))
 ; Ŀ
 ;   Get a text entity.                                                    
 ; 
  (setq entt (entget (setq enam (car (entsel "\nSelect text: ")))))
  (if (/= "TEXT" (cdr (assoc 0 entt)))
      (princ "\nThat item is not text.")
      (progn
           (setq nl (cdr (assoc 8 entt)))
           (princ "\nNew line text: ")
 ; Ŀ
 ;   Find the justification of the original entity.                        
 ; 
           (setq justrg (justo entt))
 ; Ŀ
 ;   Set the entity creation colour to that of the text, set the linetype  
 ;   to bylayer, make the entity layer current, turn it on and thaw it,    
 ;   erase the original entity.                                            
 ; 
           (if (setq ecolor (cdr (assoc 62 entt)))
               (progn
                    (if (= (type ecolor) 'INT)
                        (setq ecolor (itoa ecolor)))
                    (setvar "cecolor" ecolor))
               (setvar "cecolor" "bylayer"))
           (setvar "celtype" "bylayer")
           (command "layer" "on" nl "t" nl "s" nl "")
           (entdel enam)
 ; Ŀ
 ;   See if the text entity was drawn by an imbecile and is fixed height.  
 ; 
           (if (zerop (cdr (assoc 40 (setq styldat (tblsearch "style"
                                        (setq stnam (cdr (assoc 7 entt))))))))
               (setq zeroht t))
 ; Ŀ
 ;   Set the width scale of the style of the entity to match the width     
 ;   scale of the entity.                                                  
 ; 
           (setq wida (cdr (assoc 41 entt)))
           (stone stnam wida)
 ; Ŀ
 ;   Now create a new text entity which is identical to the selected one.  
 ;   This will allow the dtext command to pick up immediately below it.    
 ; 
           (command "text" "s" (cdr (assoc 7 entt))   ; text style
                    justrg)                           ; justification
 ; Ŀ
 ;   Find the insertion point.  If the text is left justified this will    
 ;   be the 10 point, otherwise 11, unless the justification is fit or     
 ;   aligned in which case both the ten and eleven points will be          
 ;   required.                                                             
 ;   Note that aligned text requires two end points, fitted text needs     
 ;   two points and a height, and other justifications need an insertion,  
 ;   a height, and a rotation.                                             
 ; 
           (if zeroht
               (cond ((= justrg "f")
                      (command (cdr (assoc 10 entt))
                               (cdr (assoc 11 entt))
                               (cdr (assoc 40 entt))))             ; height
                     ((= justrg "a")
                      (command (cdr (assoc 10 entt))
                               (cdr (assoc 11 entt))))
                     (t
                      (command (spit entt)                         ; insertion
                               (cdr (assoc 40 entt))               ; height
                               (* 180 (/ (cdr (assoc 50 entt)) pi))))) ; rota
               (cond ((= justrg "f")
                      (command (cdr (assoc 10 entt))
                               (cdr (assoc 11 entt))))
                     ((= justrg "a")
                      (command (cdr (assoc 10 entt))
                               (cdr (assoc 11 entt))))
                     (t
                      (command (spit entt)                         ; insertion
                               (* 180 (/ (cdr (assoc 50 entt)) pi)))))) ; rota
 ; Ŀ
 ;   Enter the original text string.                                       
 ; 
           (command (cdr (assoc 1 entt))
 ; Ŀ
 ;   Now pick up after that one with the dtext command.                    
 ; 
                    "dtext" "")))
 ; Ŀ
 ;   The user has apparently finished with Dtext and we are back in lisp.  
 ;   Reset the sysvars.                                                    
 ; 
  (*error* ())
 ; Ŀ
 ;   End.                                                                  
 ; 
 (princ))